/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.app;

import DE.siemens.ad.kop.app.KopEditorInfo;
import DE.siemens.ad.kop.app.LayoutProducerKop;
import DE.siemens.ad.kop.app.LogoComfortKOP;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerException;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerFupToKop;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.UntitledFile;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.UDFBlock;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class ConvertToKopAction
extends LogoAction {
    public ConvertToKopAction() {
        this.putValue("Name", "Convert to ladder diagram");
        this.putValue("textKey", "file.convertToKop");
        this.putValue("defaultText", "file.convertToKop");
        this.putValue("SmallIcon", Global.getIcon("Fup2Kop.gif"));
    }

    public boolean doIt() {
        Application application = Application.getInstance();
        View newKopView = application.createView(new KopEditorInfo().getEditorClassName());
        LogoComfortKOP kopEditor = (LogoComfortKOP)newKopView.getEditor();
        View currentFupView = (View)((Object)((LogoComfort)this.getOwner()).view());
        LogoDrawing oldDrawing = (LogoDrawing)currentFupView.getModel();
        WiringDiagram wiringDiagramFup = oldDrawing.getWiringDiagram();
        for (int i = 0; i < wiringDiagramFup.getBlocks().size(); ++i) {
            if (!(wiringDiagramFup.getBlocks().get(i) instanceof UDFBlock)) continue;
            JOptionPane.showMessageDialog(this.getOwner().getWindow(), "UDF exist, can not convert.", Language.getString("file.convertToKop", "Convert to LAD"), 0);
            return false;
        }
        CompilerFupToKop compilerFupToKop = new CompilerFupToKop();
        WiringDiagramKop wiringDiagramKop = null;
        try {
            wiringDiagramKop = compilerFupToKop.compile(wiringDiagramFup);
        }
        catch (CompilerException compilerException) {
            JOptionPane.showMessageDialog(this.getOwner().getWindow(), compilerException.getMessage(), Language.getString("file.convertToKop", "Convert to LAD"), 0);
            return false;
        }
        kopEditor.setWiringDiagram(wiringDiagramKop);
        LayoutProducerKop layoutProducer = new LayoutProducerKop((LogoDrawingView)newKopView, wiringDiagramKop.getBlocks());
        layoutProducer.layout();
        LogoDrawing currentDrawing = (LogoDrawing)currentFupView.getModel();
        LogoDrawing newDrawing = (LogoDrawing)newKopView.getModel();
        compilerFupToKop.transferComments(currentDrawing, newDrawing);
        newDrawing.getInputNamesManager().copyInputOutputNamesFrom(currentDrawing.getInputNamesManager());
        newDrawing.updateInputNames();
        if (newKopView != null) {
            String fileName = Util.stripFileExtension(oldDrawing.getFile().getName());
            boolean filenameUsed = false;
            do {
                filenameUsed = false;
                Iterator i = application.getMdiManager().getViews().iterator();
                View testView = null;
                while (i.hasNext() && !filenameUsed) {
                    testView = (View)i.next();
                    if (!testView.getModel().getFile().getName().equals(fileName) || !testView.getEditor().getEditorInfo().getName().equals(newKopView.getEditor().getEditorInfo().getName())) continue;
                    filenameUsed = true;
                }
                if (!filenameUsed) continue;
                fileName = Util.incrementFilenameNumber(fileName);
            } while (filenameUsed);
            newDrawing.setFile(new UntitledFile(fileName));
            application.addDocument(newKopView);
        }
        return true;
    }

    public boolean needsWaitCursor() {
        return true;
    }
}

